/**
 * Centronium Wallet — Content Script
 * Injects the Centronium provider (window.centronium) into web pages
 * and relays messages between the page and the extension background.
 */

// Inject the provider script
const script = document.createElement('script');
script.src = chrome.runtime.getURL('inject.js');
script.onload = () => script.remove();
(document.head || document.documentElement).appendChild(script);

// Relay messages from page → background
window.addEventListener('message', async (event) => {
  if (event.source !== window) return;
  if (event.data?.target !== 'centronium-extension') return;

  try {
    const response = await chrome.runtime.sendMessage(event.data.payload);
    window.postMessage({
      target: 'centronium-page',
      id: event.data.id,
      response,
    }, '*');
  } catch (e) {
    window.postMessage({
      target: 'centronium-page',
      id: event.data.id,
      response: { error: e.message },
    }, '*');
  }
});

// Listen for background → page messages
chrome.runtime.onMessage.addListener((msg) => {
  if (msg.type === 'ACCOUNT_CHANGED' || msg.type === 'NETWORK_CHANGED') {
    window.postMessage({ target: 'centronium-page', event: msg }, '*');
  }
});
